<?php
// Exit if accessed directly
if( !defined('ABSPATH') ) exit;

/**
 * Plugin Setup Functions
 *
 * @package Easy Digital Downloads - Social Login
 * @since 2.4.2
 */

/**
 * Manage plugin default settings on
 * plugin install
 *
 * @package Easy Digital Downloads - Social Login
 * @since 2.4.2
 */
function edd_slg_manage_plugin_install_settings() {
	
	global $wpdb, $edd_options;

	// Default Options Saving to Options of EDD Start
	$udpopt = false;

	//check social login header is not set
	if( !isset($edd_options['edd_slg_login_heading']) ) {
		$edd_options['edd_slg_login_heading'] = esc_html__( 'Prefer to Login with Social Media', 'eddslg' );
		$udpopt = true;
	}

	//check social login enable notification is not set
	if( !isset($edd_options['edd_slg_enable_notification']) ) {
		$edd_options['edd_slg_enable_notification'] = '';
		$udpopt = true;
	}

	//check social login redirect url is not set
	if( !isset($edd_options['edd_slg_redirect_url']) ) {
		$edd_options['edd_slg_redirect_url'] = '';
		$udpopt = true;
	}

	//check social login button shown on login options or not
	if( !isset($edd_options['edd_slg_enable_login_options']) ) {
		$edd_options['edd_slg_enable_login_options'] = array(
			'edd_checkout' => esc_html__( 'Check this box to add social login buttons on Easy Digital Downloads checkout page.', 'eddslg' ),
		);
		$udpopt = true;
	}

	//check social login button shown on myaccount page or not
	if( !isset($edd_options['edd_slg_display_link_thank_you']) ) {
		$edd_options['edd_slg_display_link_thank_you'] = '';
		$udpopt = true;
	}

	//check social login enable facebook is not set
	if( !isset($edd_options['edd_slg_enable_facebook']) ) {
		$edd_options['edd_slg_enable_facebook'] = '';
		$udpopt = true;
	}

	//check social login facebook app id is not set
	if( !isset($edd_options['edd_slg_fb_app_id']) ) {
		$edd_options['edd_slg_fb_app_id'] = '';
		$udpopt = true;
	}

	//check social login facebook app secret is not set
	if( !isset($edd_options['edd_slg_fb_app_secret']) ) {
		$edd_options['edd_slg_fb_app_secret'] = '';
		$udpopt = true;
	}

	//check social login facebook language is not set
	if( !isset($edd_options['edd_slg_fb_language']) ) {
		$edd_options['edd_slg_fb_language'] = 'en_US';
		$udpopt = true;
	}

	//check social button position is not set
	if( !isset($edd_options['edd_slg_social_btn_position']) ) {
		$edd_options['edd_slg_social_btn_position'] = 'bottom';
		$udpopt = true;
	}

	//check social login facebook button icon url is not set
	if( !isset($edd_options['edd_slg_fb_icon_url']) ) {
		$edd_options['edd_slg_fb_icon_url'] = EDD_SLG_IMG_URL . '/facebook.png';
		$udpopt = true;
	}

	//check social login enable facebook avatar is not set
	if( !isset($edd_options['edd_slg_enable_fb_avatar']) ) {
		$edd_options['edd_slg_enable_fb_avatar'] = '';
		$udpopt = true;
	}

	//check social login googleplus enable is not set
	if( !isset($edd_options['edd_slg_enable_googleplus']) ) {
		$edd_options['edd_slg_enable_googleplus'] = '';
		$udpopt = true;
	}

	//check social login googleplus client id is not set
	if( !isset($edd_options['edd_slg_gp_client_id']) ) {
		$edd_options['edd_slg_gp_client_id'] = '';
		$udpopt = true;
	}

	//check social login googleplus client id is not set
	//check social login googleplus icon url is not set
	if( !isset($edd_options['edd_slg_gp_icon_url']) ) {
		$edd_options['edd_slg_gp_icon_url'] = EDD_SLG_IMG_URL . '/googleplus.png';
		$udpopt = true;
	}

	//check social login enable google plus avatar is not set
	if( !isset($edd_options['edd_slg_enable_gp_avatar']) ) {
		$edd_options['edd_slg_enable_gp_avatar'] = '';
		$udpopt = true;
	}

	//check social login linkedin enabled is not set
	if( !isset($edd_options['edd_slg_enable_linkedin']) ) {
		$edd_options['edd_slg_enable_linkedin'] = '';
		$udpopt = true;
	}

	//check social login linkedin app scope is not set
	if( !isset($edd_options['edd_slg_li_scope_type']) ) {
		$edd_options['edd_slg_li_scope_type'] = 'signin';
		$udpopt = true;
	}

	//check social login linkedin app id is not set
	if( !isset($edd_options['edd_slg_li_app_id']) ) {
		$edd_options['edd_slg_li_app_id'] = '';
		$udpopt = true;
	}

	//check social login linkedin app secret is not set
	if( !isset($edd_options['edd_slg_li_app_secret']) ) {
		$edd_options['edd_slg_li_app_secret'] = '';
		$udpopt = true;
	}

	//check social login linkedin icon url id is not set
	if( !isset($edd_options['edd_slg_li_icon_url']) ) {
		$edd_options['edd_slg_li_icon_url'] = EDD_SLG_IMG_URL . '/linkedin.png';
		$udpopt = true;
	}

	//check social login enable linkedIn avatar is not set
	if( !isset($edd_options['edd_slg_enable_li_avatar']) ) {
		$edd_options['edd_slg_enable_li_avatar'] = '';
		$udpopt = true;
	}

	//check social login twitter enabled is not set
	if( !isset($edd_options['edd_slg_enable_twitter']) ) {
		$edd_options['edd_slg_enable_twitter'] = '';
		$udpopt = true;
	}

	//check social login twitter consumer key is not set
	if( !isset($edd_options['edd_slg_tw_consumer_key']) ) {
		$edd_options['edd_slg_tw_consumer_key'] = '';
		$udpopt = true;
	}

	//check social login twitter consumer secret is not set
	if( !isset($edd_options['edd_slg_tw_consumer_secret']) ) {
		$edd_options['edd_slg_tw_consumer_secret'] = '';
		$udpopt = true;
	}

	//check social login twitter icon url is not set
	if( !isset($edd_options['edd_slg_tw_icon_url']) ) {
		$edd_options['edd_slg_tw_icon_url'] = EDD_SLG_IMG_URL . '/twitter.png';
		$udpopt = true;
	}

	//check social login enable twitter avatar is not set
	if( !isset($edd_options['edd_slg_enable_tw_avatar']) ) {
		$edd_options['edd_slg_enable_tw_avatar'] = '';
		$udpopt = true;
	}

	//check social login yahoo enabled is not set
	if( !isset($edd_options['edd_slg_enable_yahoo']) ) {
		$edd_options['edd_slg_enable_yahoo'] = '';
		$udpopt = true;
	}

	//check social login yahoo consumer key is not set
	if( !isset($edd_options['edd_slg_yh_consumer_key']) ) {
		$edd_options['edd_slg_yh_consumer_key'] = '';
		$udpopt = true;
	}

	//check social login yahoo consumer secret is not set
	if( !isset($edd_options['edd_slg_yh_consumer_secret']) ) {
		$edd_options['edd_slg_yh_consumer_secret'] = '';
		$udpopt = true;
	}

	//check social login yahoo icon url is not set
	if( !isset($edd_options['edd_slg_yh_icon_url']) ) {
		$edd_options['edd_slg_yh_icon_url'] = EDD_SLG_IMG_URL . '/yahoo.png';
		$udpopt = true;
	}

	//check social login enable yahoo avatar is not set
	if( !isset($edd_options['edd_slg_enable_yh_avatar']) ) {
		$edd_options['edd_slg_enable_yh_avatar'] = '';
		$udpopt = true;
	}

	//check social login foursquare enable is not set
	if( !isset($edd_options['edd_slg_enable_foursquare']) ) {
		$edd_options['edd_slg_enable_foursquare'] = '';
		$udpopt = true;
	}

	//check social login foursquare client id is not set
	if( !isset($edd_options['edd_slg_fs_client_id']) ) {
		$edd_options['edd_slg_fs_client_id'] = '';
		$udpopt = true;
	}

	//check social login foursquare client secret is not set
	if( !isset($edd_options['edd_slg_fs_client_secret']) ) {
		$edd_options['edd_slg_fs_client_secret'] = '';
		$udpopt = true;
	}

	//check social login foursquare icon url is not set
	if( !isset($edd_options['edd_slg_fs_icon_url']) ) {
		$edd_options['edd_slg_fs_icon_url'] = EDD_SLG_IMG_URL . '/foursquare.png';
		$udpopt = true;
	}

	//check social login enable foursquare avatar is not set
	if( !isset($edd_options['edd_slg_enable_fs_avatar']) ) {
		$edd_options['edd_slg_enable_fs_avatar'] = '';
		$udpopt = true;
	}

	//check social login windowslive enable is not set
	if( !isset($edd_options['edd_slg_enable_windowslive']) ) {
		$edd_options['edd_slg_enable_windowslive'] = '';
		$udpopt = true;
	}

	//check social login windowslive client id is not set
	if( !isset($edd_options['edd_slg_wl_client_id']) ) {
		$edd_options['edd_slg_wl_client_id'] = '';
		$udpopt = true;
	}

	//check social login windowslive client secret is not set
	if( !isset($edd_options['edd_slg_wl_client_secret']) ) {
		$edd_options['edd_slg_wl_client_secret'] = '';
		$udpopt = true;
	}

	//check social login windowslive icon url is not set
	if( !isset($edd_options['edd_slg_wl_icon_url']) ) {
		$edd_options['edd_slg_wl_icon_url'] = EDD_SLG_IMG_URL . '/windowslive.png';
		$udpopt = true;
	}

	//check social login enable vk is not set
	if( !isset($edd_options['edd_slg_enable_vk']) ) {
		$edd_options['edd_slg_enable_vk'] = '';
		$udpopt = true;
	}

	//check social login vk app id is not set
	if( !isset($edd_options['edd_slg_vk_app_id']) ) {
		$edd_options['edd_slg_vk_client_id'] = '';
		$udpopt = true;
	}

	//check social login vk app secret is not set
	if( !isset($edd_options['edd_slg_vk_app_secret']) ) {
		$edd_options['edd_slg_vk_client_secret'] = '';
		$udpopt = true;
	}

	//check social login vk button icon url is not set
	if( !isset($edd_options['edd_slg_vk_icon_url']) ) {
		$edd_options['edd_slg_vk_icon_url'] = EDD_SLG_IMG_URL . '/vk.png';
		$udpopt = true;
	}

	//check social login enable vk avatar is not set
	if( !isset($edd_options['edd_slg_enable_vk_avatar']) ) {
		$edd_options['edd_slg_enable_vk_avatar'] = '';
		$udpopt = true;
	}

	//check social link icon for facebook
    if( !isset($edd_options['edd_slg_fb_link_icon_url']) ) {
        $edd_options['edd_slg_fb_link_icon_url'] = EDD_SLG_IMG_URL . '/facebook-link.png';
        $udpopt = true;
    }

    //check social link icon for google+
    if( !isset($edd_options['edd_slg_gp_link_icon_url']) ) {
        $edd_options['edd_slg_gp_link_icon_url'] = EDD_SLG_IMG_URL . '/googleplus-link.png';
        $udpopt = true;
    }

    //check social link icon for linkdin
    if( !isset($edd_options['edd_slg_li_link_icon_url']) ) {
        $edd_options['edd_slg_li_link_icon_url'] = EDD_SLG_IMG_URL . '/linkedin-link.png';
        $udpopt = true;
    }

    //check social link icon for twitter
    if( !isset($edd_options['edd_slg_tw_link_icon_url']) ) {
        $edd_options['edd_slg_tw_link_icon_url'] = EDD_SLG_IMG_URL . '/twitter-link.png';
        $udpopt = true;
    }

    //check social link icon for yahoo
    if( !isset($edd_options['edd_slg_yh_link_icon_url']) ) {
        $edd_options['edd_slg_yh_link_icon_url'] = EDD_SLG_IMG_URL . '/yahoo-link.png';
        $udpopt = true;
    }

    //check social link icon for foursquare
    if( !isset($edd_options['edd_slg_fs_link_icon_url']) ) {
        $edd_options['edd_slg_fs_link_icon_url'] = EDD_SLG_IMG_URL . '/foursquare-link.png';
        $udpopt = true;
    }

    //check social link icon for windows live
    if( !isset($edd_options['edd_slg_wl_link_icon_url']) ) {
        $edd_options['edd_slg_wl_link_icon_url'] = EDD_SLG_IMG_URL . '/windowslive-link.png';
        $udpopt = true;
    }

    //check social link icon for VK
    if( !isset($edd_options['edd_slg_vk_link_icon_url']) ) {
        $edd_options['edd_slg_vk_link_icon_url'] = EDD_SLG_IMG_URL . '/vk-link.png';
        $udpopt = true;
    }

    //check social login enable amazon is not set
    if( !isset($edd_options['edd_slg_enable_amazon']) ) {
        $edd_options['edd_slg_enable_amazon'] = '';
        $udpopt = true;
    }

    //check social login amazon app id is not set
    if( !isset($edd_options['edd_slg_amazon_app_id']) ) {
        $edd_options['edd_slg_amazon_app_id'] = '';
        $udpopt = true;
    }

    //check social login amazon app secret is not set
    if( !isset($edd_options['edd_slg_amazon_app_secret']) ) {
        $edd_options['edd_slg_amazon_app_secret'] = '';
        $udpopt = true;
    }

    //check social login amazon button icon url is not set
    if( !isset($edd_options['edd_slg_amazon_icon_url']) ) {
        $edd_options['edd_slg_amazon_icon_url'] = EDD_SLG_IMG_URL . '/amazon.png';
        $udpopt = true;
    }

    //check social link icon for amazon
    if( !isset($edd_options['edd_slg_amazon_link_icon_url']) ) {
        $edd_options['edd_slg_amazon_link_icon_url'] = EDD_SLG_IMG_URL . '/amazon-link.png';
        $udpopt = true;
    }

    //check social login enable paypal is not set
    if( !isset($edd_options['edd_slg_enable_paypal']) ) {
        $edd_options['edd_slg_enable_paypal'] = '';
        $udpopt = true;
    }

    //check social login paypal app id is not set
    if( !isset($edd_options['edd_slg_paypal_app_id']) ) {
        $edd_options['edd_slg_paypal_app_id'] = '';
        $udpopt = true;
    }

    //check social login paypal app secret is not set
    if( !isset($edd_options['edd_slg_paypal_app_secret']) ) {
        $edd_options['edd_slg_paypal_app_secret'] = '';
        $udpopt = true;
    }

    //check social login paypal button icon url is not set
    if( !isset($edd_options['edd_slg_paypal_icon_url']) ) {
        $edd_options['edd_slg_paypal_icon_url'] = EDD_SLG_IMG_URL . '/paypal.png';
        $udpopt = true;
    }

    //check social link icon for paypal
    if( !isset($edd_options['edd_slg_paypal_link_icon_url']) ) {
        $edd_options['edd_slg_paypal_link_icon_url'] = EDD_SLG_IMG_URL . '/paypal-link.png';
        $udpopt = true;
    }

    //check social login apple signin all options are set or not
    if( !isset($edd_options['edd_slg_enable_apple']) ) {
        $edd_options['edd_slg_enable_apple'] = '';
        $udpopt = true;
    }

    //check social login paypal app id is not set
    if( !isset($edd_options['edd_slg_apple_client_id']) ) {
        $edd_options['edd_slg_apple_client_id'] = '';
        $udpopt = true;
    }

    //check social login paypal button icon url is not set
    if( !isset($edd_options['edd_slg_apple_icon_url']) ) {
        $edd_options['edd_slg_apple_icon_url'] = EDD_SLG_IMG_URL . '/apple.png';
        $udpopt = true;
    }

    //check social link icon for paypal
    if( !isset($edd_options['edd_slg_apple_link_icon_url']) ) {
        $edd_options['edd_slg_apple_link_icon_url'] = EDD_SLG_IMG_URL . '/apple-link.png';
        $udpopt = true;
    }

    //check need to update the defaults value to options
    if( $udpopt == true ) { // if any of the settings need to be updated
        update_option( 'edd_settings', $edd_options );
    }

    //get option for when plugin is activating first time
    $edd_slg_set_option = get_option( 'edd_slg_set_option' );

    //get social order options
    $edd_social_order = get_option( 'edd_social_order' );

    //check plugin version option
    if( empty($edd_social_order) ) {
        $edd_social_order = array(
        	'facebook', 'twitter', 'googleplus',
        	'linkedin', 'yahoo', 'foursquare', 'windowslive'
        );

        update_option('edd_social_order', $edd_social_order);
        
        //update plugin version to option 
        update_option('edd_slg_set_option', '1.0');
    }

    $edd_slg_set_option = get_option( 'edd_slg_set_option' );

    if( $edd_slg_set_option == '1.0' ) {

        $vk_array = array( 'vk' );
        $edd_social_order = array_merge( $edd_social_order, $vk_array );

        update_option( 'edd_social_order', $edd_social_order );
        
        //update plugin version to option 
        update_option( 'edd_slg_set_option', '1.1' );
    }

    $edd_slg_set_option = get_option( 'edd_slg_set_option' );
    if( $edd_slg_set_option == '1.1' ) {
        //update plugin version to option 
        update_option('edd_slg_set_option', '1.2');
    }

    $edd_slg_set_option = get_option( 'edd_slg_set_option' );
    if( $edd_slg_set_option == '1.2' ) {

        // Amazon and paypal api added in api array
        $authorize_array = array( 'amazon', 'paypal' );
        $edd_social_order = array_merge( $edd_social_order, $authorize_array );
        update_option( 'edd_social_order', $edd_social_order );

        // Amazon and paypal options
        $authorize_options = array(
            'edd_slg_enable_amazon' => '',
            'edd_slg_amazon_app_id' => '',
            'edd_slg_amazon_app_secret' => '',
            'edd_slg_amazon_icon_url' => EDD_SLG_IMG_URL . '/amazon.png',
            'edd_slg_amazon_link_icon_url' => EDD_SLG_IMG_URL . '/amazon-link.png',
            'edd_slg_enable_paypal' => '',
            'edd_slg_paypal_app_id' => '',
            'edd_slg_paypal_app_secret' => '',
            'edd_slg_paypal_icon_url' => EDD_SLG_IMG_URL . '/paypal.png',
            'edd_slg_paypal_link_icon_url' => EDD_SLG_IMG_URL . '/paypal-link.png',
            'edd_slg_paypal_environment' => 'sandbox',
        );

        foreach( $authorize_options as $key => $value ) {
            update_option( $key, $value );
        }

        //update plugin version to option
        update_option( 'edd_slg_set_option', '1.3' );
    }

    //get social order options
    $edd_slg_set_option = get_option( 'edd_slg_set_option' );

    if( $edd_slg_set_option == '1.3' ) {

        // Future code will be here.
        if( class_exists('Easy_Digital_Downloads') ) {

            $edd_slg_enable_login_page = edd_get_option( 'edd_slg_enable_login_page' );

            if( !empty($edd_slg_enable_login_page) ) {
                edd_update_option( 'edd_slg_enable_login_options', array(
                    'edd_login' => esc_html__('Check this box to add social login buttons on Easy Digital Downloads login page.', 'eddslg'),
                    'edd_checkout' => esc_html__('Check this box to add social login buttons on Easy Digital Downloads checkout page.', 'eddslg'),
                    'wp_login' => esc_html__('Check this box to add social login buttons on default WordPress login page.', 'eddslg'),
                ) );
            }

            //update plugin version to option
            update_option( 'edd_slg_set_option', '1.4' );
        }
    }

    //get social order options
    $edd_slg_set_option = get_option( 'edd_slg_set_option' );

    if( $edd_slg_set_option == '1.4' ) {

        //check caching setting option
        if( !isset($edd_options['edd_slg_enable_caching_resolution']) ) {
            $edd_options['edd_slg_enable_caching_resolution'] = '';
            $udpopt = true;
        }

        //check need to update the defaults value to options
        if( $udpopt == true ) { // if any of the settings need to be updated
            update_option( 'edd_settings', $edd_options );
        }

        //update plugin version to option
        update_option( 'edd_slg_set_option', '1.5' );
    }

    //get social order options
    $edd_slg_set_option = get_option( 'edd_slg_set_option' );
   
    if( $edd_slg_set_option == '1.5' ) {

        global $edd_options;

        $apple_array = array( 'apple' );
        $edd_social_order = array_merge( $edd_social_order, $apple_array );

        update_option( 'edd_social_order', $edd_social_order );
        $edd_slg_enable_apple = $edd_options['edd_slg_enable_apple'];
        $edd_slg_apple_client_id = $edd_options['edd_slg_apple_client_id'];

        if( empty($edd_slg_enable_apple) ){
           $edd_options['edd_slg_enable_apple'] = '';
        }

       $edd_options['edd_slg_apple_icon_url'] = esc_url( EDD_SLG_IMG_URL ) . '/apple.png';
       $edd_options['edd_slg_apple_link_icon_url'] = esc_url( EDD_SLG_IMG_URL ) . '/apple-link.png';

       update_option( 'edd_settings', $edd_options );
       update_option( 'edd_slg_set_option', '1.6' );
    }

    //get social order options
    $edd_slg_set_option = get_option( 'edd_slg_set_option' );

    if( $edd_slg_set_option == '1.6' ) {

        global $edd_options;
        
        //get social order options
        $edd_social_order = get_option( 'edd_social_order' );
        
        $search = array_search( 'instagram', $edd_social_order );

        if( $search !== false ) {
            unset( $edd_social_order[$search] );

            $edd_social_order = array_values( $edd_social_order );
            update_option( 'edd_social_order', $edd_social_order );
        }
        
        update_option( 'edd_slg_set_option', '1.7' );
    }
}